precision highp float;

uniform sampler2D u_TextureUnit;
varying vec2 v_TexCoords;
varying float v_Alpha;

uniform highp float widthOfset;
uniform highp float heightOfset;
uniform highp float gaussianWeights[961];
uniform highp int blurRadius;
uniform mat4 uColorFilter;

void main(){
    if(blurRadius == 0){
        vec4 texColor = texture2D(u_TextureUnit, v_TexCoords);
        gl_FragColor = uColorFilter * texColor * v_Alpha;
//            gl_FragColor = vec4(1.0, 0.0, 0.0, 1.0);
    }else{
        highp vec2 offset = vec2(widthOfset,heightOfset);
        highp vec4 sum = vec4(0.0);
        highp int x = 0;
        for (int i = -blurRadius; i <= blurRadius; i++) {
            for (int j = -blurRadius; j <= blurRadius; j++) {
                highp float weight = gaussianWeights[x];
                sum += (texture2D(u_TextureUnit, v_TexCoords + offset * vec2(i,j)) * weight);
                x++;
            }
        }
        gl_FragColor = sum * v_Alpha;
//        gl_FragColor = vec4(1.0 * blurRadius, 0.0, 0.0, 1.0);
    }

}